//This program generates the naturally sampled version of  sin(20.pi.t)and simulates its recovery from the sampled version //Windows 10
//Scilab 6.1.0
clear
clc
t1=input('Enter the lower limit of time axis:')
t2=input('Enter the upper limit of time axis:')
s=input('Enter the spacing between the adjacent value of time axis:')
t=t1:s:t2;
t1=ones(1,length(t));
f=input('Enter the baseband signal frequency:')
x=sin(2*%pi*f*t);
n=input('Enter the integer which decides the width of the pulse:')
sa=[0 ones(1,n) zeros(1,n)]
//Generation of Sampling signal which is a rectangular Pulse Train
while length(sa)<=length(t)
    sa=[sa ones(1,n) zeros(1,n)]
end
sa(length(t)+1:length(sa))=[];
//Generation of sampled Signal
NAT=sa.*x;
//Reconstruction Filter
RC=1/(2*%pi*f);
h=(1/RC)*exp(-t/RC);
//Signal reconstruction
y=conv(h,conv(h,NAT));
subplot(4,1,1)
plot(t,x)
plot(t,x,'linewidth',3)
xgrid
xtitle("Baseband signal of frquency 10Hz(to be Sampled)","Time","Amplitude")
subplot(4,1,2)
plot(t,sa,'linewidth',3)
xgrid
xtitle("Rectangular Pulse Train(Sampling Signal)","Time","Amplitude")
subplot(4,1,3)
plot(t,NAT,'linewidth',3)
xgrid
xtitle(" Sampled Signal under Natural Sampling","Time","Amplitude")
subplot(4,1,4)
plot(t,y(1:length(t))/length(y),'linewidth',2)
xgrid
xtitle("Recovered Signal","Time","Amplitude")


//Testcase
// lower limit of time axis: 0
//upper limit of time axis: 0.2
//spacing between the adjacent value of time axis: 0.001
// baseband signal frequency: 10
//integer which decides the width of the pulse: 4
